@echo off
setlocal
:: GameDataConvert.bat
:: Based on a vanilla Oni (Windows or Mac) GameDataFolder, creates a GameDataFolderX for use with OniX.exe.
:: This version of the script is written in a simpler dialect of Batch in order to be compatible with Wine.

SET HAS_SEP=0
SET RAWSEP_MISSING=0

echo == OniX game data converter v1.3 ==

REM ==========================
echo Inspecting Oni environment...
IF NOT EXIST GameDataTool.exe (
    echo GameDataTool not found. GameDataTool.exe needs to be placed alongside this
    echo script.
    PAUSE
    EXIT
)

IF NOT EXIST "GameDataFolder\" (
    echo There is no GameDataFolder present here. The folder needs to be placed alongside
    echo this script. If you do not own a copy of Oni, you can download the demo from Oni
    echo Mod Depot. Visit http://mods.oni2.net/ and search for 'demo' to get it.
    PAUSE
    EXIT
)

SET PRIOR_GDFX=0
IF EXIST "GameDataFolderX\" (
    REM We are not concerned with other things that might be in GDFX, just the level files
    IF EXIST "GameDataFolderX\level*.dat" (
        SET PRIOR_GDFX=1
    )
    IF EXIST "GameDataFolderX\level*.raw" (
        SET PRIOR_GDFX=1
    )
    IF EXIST "GameDataFolderX\level*.sep" (
        SET PRIOR_GDFX=1
    )
)

IF %PRIOR_GDFX%==1 (
    echo Existing GameDataFolderX detected. Your previously-converted game data will
    echo be overwritten. Do you want to remove the previous contents of
    echo GameDataFolderX and run the conversion again?
)
IF %PRIOR_GDFX%==1 (
    SET /p CHOICE="(y/n) "
)
IF %PRIOR_GDFX%==1 (
    IF /I "%CHOICE%"=="y" (
        DEL "GameDataFolderX\level*.dat" 2> nul
        DEL "GameDataFolderX\level*.raw" 2> nul
        DEL "GameDataFolderX\level*.sep" 2> nul
        echo Removed previous conversion products in GameDataFolderX.
    )
)
IF %PRIOR_GDFX%==1 (
    IF /I NOT "%CHOICE%"=="y" (
        EXIT
    )
)

SET PRIOR_CONV=0
FOR %%F IN (GameDataFolder\level*.dat) DO (
    IF EXIST "GameDataFolder\%%~nF" (
        SET PRIOR_CONV=1
    )
    IF EXIST "GameDataFolder\%%~nF.log" (
        SET PRIOR_CONV=1
    )
)
IF %PRIOR_CONV%==1 (
    echo Products of an earlier conversion detected in GameDataFolder. Do you want to
    echo remove them and run the conversion again?
)
IF %PRIOR_CONV%==1 (
    SET /p CHOICE="(y/n) "
)
IF %PRIOR_CONV%==1 (
    IF /I "%CHOICE%"=="y" (
        FOR %%F IN (GameDataFolder\level*.dat) DO (
            IF EXIST "GameDataFolder\%%~nF" (
                RMDIR "GameDataFolder\%%~nF" /q /s
            )
            IF EXIST "GameDataFolder\%%~nF.log" (
                DEL "GameDataFolder\%%~nF.log" 2> nul
            )
        )
        echo Removed previous conversion products in GameDataFolder.
    )
)
IF %PRIOR_CONV%==1 (
    IF /I NOT "%CHOICE%"=="y" (
        EXIT
    )
)

IF %PRIOR_GDFX%==0 (
    IF %PRIOR_CONV%==0 (
        echo All clear.
    )
)

REM ==========================
echo Checking for game data...
SET FAILED_RETAIL_VAL=0
SET FAILED_DEMO_VAL=0
FOR %%N IN (0 1 2 3 4 6 8 9 10 11 12 13 14 18 19) DO (
    IF NOT EXIST "GameDataFolder\level%%N_Final.dat" (
        echo level%%N_Final.dat not found.
        SET FAILED_RETAIL_VAL=1
    )
)

IF "%FAILED_RETAIL_VAL%"=="1" (
    GOTO DEMO_CHECK
)
GOTO RETAIL_OK

:DEMO_CHECK
echo Retail check failed. Proceeding to demo-level check...
SET FAILED_DEMO_VAL=0
FOR %%N IN (0 1 2 4) DO (
    IF NOT EXIST GameDataFolder\level%%N_Final.dat (
        echo level%%N_Final.dat not found.
        SET FAILED_DEMO_VAL=1
    )
)

IF "%FAILED_DEMO_VAL%"=="1" (
    GOTO DATA_MISSING
)
GOTO DEMO_VERSION

:DATA_MISSING
echo Some of the game data files needed for running Oni are missing. Supply a
echo retail or demo copy of Oni. Visit http://mods.oni2.net/ and search for
echo 'demo' to get the demo.
PAUSE
EXIT /B

:DEMO_VERSION
echo This is the demo installation of Oni. There's no need to convert it if this
echo is the Windows demo, as the game data uses the same format as OniX. If this
echo is the Mac demo, you should visit http://mods.oni2.net/, search for 'demo',
echo and download the Windows version, which comes with OniX and is ready to play.
PAUSE
EXIT /B

:RETAIL_OK
echo Retail data detected.

REM ==========================
echo Determining platform version of game data...
IF EXIST "GameDataFolder\level*.sep" (
    SET HAS_SEP=1
    echo Found some .sep files; assuming this is Mac data.
) ELSE (
    echo No .sep files detected; assuming this is Windows data.
)

REM ==========================
echo Ensuring completeness of game data...
FOR %%F IN (GameDataFolder\level*.dat) DO (
    CALL :CHECK_FILES "%%~nF"
)
GOTO AFTER_CHECK

:CHECK_FILES
IF NOT EXIST "GameDataFolder\%~1.raw" (
    SET RAWSEP_MISSING=1
    echo %~1.raw not found.
)
IF %HAS_SEP%==1 (
    IF NOT EXIST "GameDataFolder\%~1.sep" (
        SET RAWSEP_MISSING=1
        echo %~1.sep not found.
    )
)
EXIT /B

:AFTER_CHECK
IF %RAWSEP_MISSING%==1 (
    echo GameDataFolder needs to contain a full set of game data files. The file^(s^) above are missing.
    PAUSE
    EXIT
)
echo All needed files present.

REM ==========================
echo Testing conversion tool...
GameDataTool -export:TXMPKONdeepthought "GameDataFolder\level0_Final" "GameDataFolder\level0_Final.dat" > nul
IF errorLevel 1 (
    echo This script does not seem to have sufficient privileges to write to
    echo GameDataFolder. Are you an administrator? Do you have ownership of the Oni
    echo folder? You could try moving the entire Oni folder to another drive, or to your
    echo desktop. If that does not work, you will need to get Properties on the Oni
    echo folder and use the Security tab to give yourself more rights to it and all
    echo subfolders.
    PAUSE
    EXIT
)
IF NOT EXIST "GameDataFolder\level0_Final\TXMPKONdeepthought.oni" (
   echo Test conversion failed. Is there a prompt onscreen to install .NET? Please
   echo follow the prompt, or otherwise install .NET 3.5, and then run this script
   echo again. You can install .NET 3.5 from within Windows by opening the Start
   echo Menu, typing "features", then select "Turn Windows features on or off".
   echo The window that opens will contain a checkbox for .NET 3.5; check this and
   echo click OK.
   PAUSE
   EXIT
)
RMDIR "GameDataFolder\level0_Final" /q /s
echo Conversion test successful.

REM ==========================
echo Converting the game data...
FOR %%F IN (GameDataFolder\level*.dat) DO CALL :PROCESS_FILE "%%~nF"
GOTO :FILE_COPY

:PROCESS_FILE
echo Exporting vanilla-format %~1...
GameDataTool -export "GameDataFolder\%~1" "GameDataFolder\%~1.dat" > "GameDataFolder\%~1.log"
IF errorlevel 1 CALL :TELL_USER "%~1"

GameDataTool -move "GameDataFolder\%~1\SNDD" "GameDataFolder\%~1\SNDD*.oni" > nul
IF errorlevel 1 CALL :TELL_USER "%~1"

echo Extracting sounds...
IF EXIST "GameDataFolder\%~1.sep" (
    GameDataTool -extract:aif "GameDataFolder\%~1\SNDD\aif" "GameDataFolder\%~1\SNDD\SNDD*.oni" >> "GameDataFolder\%~1.log" 2>&1
    IF errorlevel 1 CALL :TELL_USER "%~1"
    echo Reformatting sounds...
    GameDataTool -create "GameDataFolder\%~1" -demo -forcestd "GameDataFolder\%~1\SNDD\aif\SNDD*.aif" >> "GameDataFolder\%~1.log"
    IF errorlevel 1 CALL :TELL_USER "%~1"
) ELSE (
    GameDataTool -extract:wav "GameDataFolder\%~1\SNDD\wav" "GameDataFolder\%~1\SNDD\SNDD*.oni" >> "GameDataFolder\%~1.log" 2>&1
    IF errorlevel 1 CALL :TELL_USER "%~1"
    echo Reformatting sounds...
    GameDataTool -create "GameDataFolder\%~1" -demo -forcestd "GameDataFolder\%~1\SNDD\wav\SNDD*.wav" >> "GameDataFolder\%~1.log"
    IF errorlevel 1 CALL :TELL_USER "%~1"
)
echo Creating OniX-format %~1...
GameDataTool -import:onix "GameDataFolder\%~1" "GameDataFolderX\%~1.dat" >> "GameDataFolder\%~1.log"
IF errorlevel 1 CALL :TELL_USER "%~1"
echo Deleting temp folder %~1...
RMDIR "GameDataFolder\%~1" /q /s
EXIT /B

:TELL_USER
echo An error was encountered while converting the game data.
echo Look at GameDataFolder\%~1.log to see the issue.
PAUSE
EXIT

:FILE_COPY
echo Copying level scripts...
XCOPY "GameDataFolder\IGMD" "GameDataFolderX\IGMD" /s /i /y /q
echo Copying movie files...
XCOPY "GameDataFolder\*.bik" "GameDataFolderX" /y /q

echo The conversion was completed successfully.
PAUSE
endlocal
